/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar.element;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.opengl.GL11;
import xaero.common.IXaeroMinimap;
import xaero.common.icon.XaeroIcon;
import xaero.common.interfaces.render.InterfaceRenderer;
import xaero.common.minimap.MinimapInterface;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.element.render.MinimapElementRenderer;
import xaero.common.minimap.radar.MinimapRadar;
import xaero.common.minimap.radar.category.EntityRadarCategory;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.render.radar.EntityIconManager;
import xaero.common.minimap.render.radar.element.RadarElementReader;
import xaero.common.minimap.render.radar.element.RadarRenderContext;
import xaero.common.minimap.render.radar.element.RadarRenderProvider;
import xaero.common.settings.ModSettings;

public final class RadarRenderer
extends MinimapElementRenderer<Entity, RadarRenderContext> {
    private final IXaeroMinimap modMain;
    private final EntityIconManager entityIconManager;
    private final MinimapInterface minimapInterface;

    private RadarRenderer(IXaeroMinimap modMain, EntityIconManager entityIconManager, MinimapInterface minimapInterface, RadarElementReader elementReader, RadarRenderProvider provider, RadarRenderContext context) {
        super(elementReader, provider, context);
        this.modMain = modMain;
        this.entityIconManager = entityIconManager;
        this.minimapInterface = minimapInterface;
    }

    @Override
    public void preRender(int location, Entity renderEntity, EntityPlayer player, double renderX, double renderY, double renderZ, ScaledResolution scaledRes, IXaeroMinimap modMain) {
        ModSettings settings = modMain.getSettings();
        this.entityIconManager.allowPrerender();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(InterfaceRenderer.guiTextures);
        if (settings.getSmoothDots()) {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        } else {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        }
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)771);
        ((RadarRenderContext)this.context).setupGlobalContext(settings.getDotNameScale(), settings.getSmoothDots(), settings.debugEntityIcons, settings.debugEntityVariantIds, settings.getDotsStyle(), renderEntity);
        ((RadarRenderContext)this.context).guiScale = scaledRes.func_78325_e();
    }

    @Override
    public void postRender(int location, Entity renderEntity, EntityPlayer player, double renderX, double renderY, double renderZ, ScaledResolution scaledRes, IXaeroMinimap modMain) {
        ((RadarRenderContext)this.context).renderEntity = null;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(InterfaceRenderer.guiTextures);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GlStateManager.func_179118_c();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
    }

    @Override
    public boolean renderElement(int location, boolean highlit, boolean outOfBounds, FontRenderer font, Framebuffer framebuffer, MinimapRendererHelper helper, Entity renderEntity, EntityPlayer player, double renderX, double renderY, double renderZ, int elementIndex, double optionalDepth, float optionalScale, Entity e, double partialX, double partialY, boolean cave, float partialTicks, ScaledResolution scaledRes) {
        double dotsScale;
        XaeroIcon entityHeadTexture;
        float optionScaleAdjust = this.elementReader.getBoxScale(location, e, this.context);
        optionalScale = (float)Math.ceil(optionalScale * optionScaleAdjust);
        RadarRenderContext context = (RadarRenderContext)this.context;
        int nameOffsetX = 0;
        int nameOffsetY = 0;
        GlStateManager.func_179094_E();
        boolean icon = context.icon;
        boolean name = context.name;
        XaeroIcon xaeroIcon = entityHeadTexture = icon ? this.entityIconManager.getEntityHeadTexture(e, framebuffer, helper, (float)context.iconScale, context.debugEntityIcons, context.debugEntityVariantIds, scaledRes) : null;
        if (entityHeadTexture == EntityIconManager.DOT) {
            entityHeadTexture = null;
            icon = false;
        }
        if (entityHeadTexture == EntityIconManager.FAILED) {
            entityHeadTexture = null;
        }
        float offh = (float)(renderEntity.field_70163_u - e.field_70163_u);
        GlStateManager.func_179137_b((double)partialX, (double)partialY, (double)0.0);
        GlStateManager.func_179152_a((float)optionalScale, (float)optionalScale, (float)1.0f);
        if (entityHeadTexture != null) {
            dotsScale = context.iconScale;
            double clampedScale = Math.max(1.0, dotsScale);
            GL11.glScaled((double)clampedScale, (double)clampedScale, (double)1.0);
            float brightness = context.minimapRadar.getEntityBrightness(offh, context.heightLimit, context.startFadingAt, context.heightBasedFade);
            GlStateManager.func_179120_a((int)1, (int)771, (int)1, (int)771);
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)771);
            GlStateManager.func_179144_i((int)entityHeadTexture.getTextureAtlas().getTextureId());
            if (!cave) {
                GlStateManager.func_179131_c((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
            } else {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)brightness);
            }
            helper.drawMyTexturedModalRect(-31.0f, -31.0f, entityHeadTexture.getOffsetX() + 1, entityHeadTexture.getOffsetY() + 1, 62.0f, 62.0f, entityHeadTexture.getTextureAtlas().getWidth());
        } else {
            int dotSize = context.dotSize;
            if (icon && context.displayNameWhenIconFails) {
                name = true;
            }
            dotsScale = 1.0 + 0.5 * (double)(dotSize - 1);
            int color = context.minimapRadar.getEntityColour(player, e, offh, cave, context.entityCategory, context.heightLimit, context.startFadingAt, context.heightBasedFade, context.colorIndex);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            float a = (float)(color >> 24 & 0xFF) / 255.0f;
            GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(InterfaceRenderer.guiTextures);
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)771);
            int dotTextureX = 0;
            int dotTextureY = 0;
            int dotTextureW = 0;
            int dotTextureH = 0;
            float dotOffset = 0.0f;
            double dotActualScale = 1.0;
            boolean smooth = context.smoothDots;
            if (context.dotsStyle == 1) {
                if (smooth) {
                    dotTextureX = 1;
                    dotTextureY = 88;
                } else {
                    dotsScale = (int)dotsScale;
                    dotTextureX = 9;
                    dotTextureY = 77;
                }
                dotOffset = -3.5f;
                dotTextureH = 8;
                dotTextureW = 8;
                dotActualScale = dotsScale;
                GlStateManager.func_179152_a((float)((float)dotsScale), (float)((float)dotsScale), (float)1.0f);
            } else {
                switch (dotSize) {
                    case 1: {
                        dotOffset = -4.5f;
                        dotTextureY = 108;
                        dotTextureH = 9;
                        dotTextureW = 9;
                        break;
                    }
                    case 3: {
                        dotOffset = -7.5f;
                        dotTextureY = 128;
                        dotTextureH = 15;
                        dotTextureW = 15;
                        break;
                    }
                    case 4: {
                        dotOffset = -10.5f;
                        dotTextureY = 160;
                        dotTextureH = 21;
                        dotTextureW = 21;
                        break;
                    }
                    default: {
                        dotOffset = -5.5f;
                        dotTextureY = 117;
                        dotTextureH = 11;
                        dotTextureW = 11;
                    }
                }
            }
            if (!smooth) {
                double dotRadius = (double)(-dotOffset) * dotActualScale;
                double dotRadiusPartial = dotRadius - (double)((int)dotRadius);
                nameOffsetX = partialX - dotRadiusPartial <= -0.5 ? -1 : 0;
                nameOffsetY = partialY - dotRadiusPartial < -0.5 ? -1 : 0;
            }
            helper.drawMyTexturedModalRect(dotOffset, dotOffset, dotTextureX, dotTextureY, dotTextureW, dotTextureH, 256.0f);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179152_a((float)optionalScale, (float)optionalScale, (float)1.0f);
        boolean displayY = context.displayY;
        if (name || displayY) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179129_p();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int offsetY = entityHeadTexture != null ? 11 : 5;
            GlStateManager.func_179137_b((double)nameOffsetX, (double)((long)nameOffsetY + Math.round((double)offsetY * dotsScale)), (double)optionalDepth);
            double dotNameScale = context.nameScale;
            GlStateManager.func_179152_a((float)((float)dotNameScale), (float)((float)dotNameScale), (float)1.0f);
            String yValueString = null;
            if (displayY) {
                int yInt = (int)Math.floor(e.field_70163_u);
                int pYInt = (int)Math.floor(player.field_70163_u);
                yValueString = yInt + (yInt > pYInt ? "\u2191" : (yInt != pYInt ? "\u2193" : ""));
            }
            if (name) {
                String entityName;
                if (e instanceof EntityItem) {
                    EntityItem ei = (EntityItem)e;
                    entityName = ei.func_92059_d().func_82833_r();
                } else {
                    entityName = e.func_145748_c_().func_150254_d();
                }
                if (displayY) {
                    entityName = entityName + "(" + yValueString + ")";
                }
                int nameW = font.func_78256_a(entityName);
                GlStateManager.func_179090_x();
                helper.drawMyColoredRect(-nameW / 2 - 2, -1.0f, nameW / 2 + 1, 9.0f, 0x5A000000);
                GlStateManager.func_179098_w();
                font.func_78276_b(entityName, -nameW / 2, 0, -1);
            } else if (displayY) {
                String yString = "Y: " + yValueString;
                int yStringW = font.func_78256_a(yString);
                GlStateManager.func_179090_x();
                helper.drawMyColoredRect(-yStringW / 2 - 2, -1.0f, yStringW / 2 + 1, 9.0f, 0x5A000000);
                GlStateManager.func_179098_w();
                font.func_78276_b(yString, -yStringW / 2, 0, -1);
            }
            GlStateManager.func_179141_d();
            GlStateManager.func_179092_a((int)516, (float)0.0f);
            GlStateManager.func_179089_o();
            GlStateManager.func_179121_F();
        }
        return false;
    }

    public void renderEntityDotToFBO(int location, boolean highlit, MinimapProcessor minimap, EntityPlayer p, Entity renderEntity, Entity e, float partial, boolean name, boolean icon, MinimapRadar minimapRadar, int style, boolean smooth, boolean debug, boolean debugEntityVariantIds, boolean cave, double dotNameScale, int dotIndex, boolean displayNameWhenIconFails, int heightLimit, boolean heightBasedFade, int startFadingAt, double iconScale, int dotSize, int colorIndex, boolean displayY, EntityRadarCategory category, MinimapRendererHelper helper, FontRenderer font, Framebuffer framebuffer, ScaledResolution scaledRes) {
        ((RadarRenderContext)this.context).setupGlobalContext(dotNameScale, smooth, debug, debugEntityVariantIds, style, renderEntity);
        ((RadarRenderContext)this.context).minimapRadar = minimapRadar;
        ((RadarRenderContext)this.context).name = name;
        ((RadarRenderContext)this.context).icon = icon;
        ((RadarRenderContext)this.context).displayNameWhenIconFails = displayNameWhenIconFails;
        ((RadarRenderContext)this.context).heightLimit = heightLimit;
        ((RadarRenderContext)this.context).heightBasedFade = heightBasedFade;
        ((RadarRenderContext)this.context).startFadingAt = startFadingAt;
        ((RadarRenderContext)this.context).iconScale = iconScale;
        ((RadarRenderContext)this.context).dotSize = dotSize;
        ((RadarRenderContext)this.context).colorIndex = colorIndex;
        ((RadarRenderContext)this.context).displayY = displayY;
        ((RadarRenderContext)this.context).entityCategory = category;
        this.renderElement(location, highlit, false, font, framebuffer, helper, renderEntity, p, 0.0, 0.0, 0.0, 0, 0.0, 1.0f, e, 0.0, 0.0, cave, 1.0f, scaledRes);
        ((RadarRenderContext)this.context).renderEntity = null;
    }

    @Override
    public boolean shouldRender(int location) {
        return this.minimapInterface.usingFBO() && (location == 3 || location == 4 || this.modMain.getSettings().getEntityRadar());
    }

    public static final class Builder {
        private IXaeroMinimap modMain;
        private EntityIconManager entityIconManager;
        private MinimapInterface minimapInterface;

        private Builder() {
        }

        private Builder setDefault() {
            this.setEntityIconManager(null);
            return this;
        }

        public Builder setModMain(IXaeroMinimap modMain) {
            this.modMain = modMain;
            return this;
        }

        public Builder setEntityIconManager(EntityIconManager entityIconManager) {
            this.entityIconManager = entityIconManager;
            return this;
        }

        public Builder setMinimapInterface(MinimapInterface minimapInterface) {
            this.minimapInterface = minimapInterface;
            return this;
        }

        public RadarRenderer build() {
            if (this.modMain == null || this.entityIconManager == null || this.minimapInterface == null) {
                throw new IllegalStateException();
            }
            RadarElementReader elementReader = new RadarElementReader();
            RadarRenderProvider provider = new RadarRenderProvider();
            RadarRenderContext context = new RadarRenderContext();
            return new RadarRenderer(this.modMain, this.entityIconManager, this.minimapInterface, elementReader, provider, context);
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

